function varargout = ampd(Signal)

    if ~isvector(Signal) || isscalar(Signal)
        error('Input argument ''Signal'' must be a vector')

    elseif ~isfloat(Signal)
        error('Class of input argument ''Signal'' must be ''double''')

    elseif ~isrow(Signal)
        Signal = Signal';

    end

    time = 1:numel(Signal);
    %Anlisis de regresion lineal
    [fitPolynomial,fitError] = polyfit(time,Signal,1);
    [fitSignal,~] = polyval(fitPolynomial,time,fitError);

    dtrSignal = Signal - fitSignal;

    N = length(dtrSignal);
    L = ceil(N/2)-1;

    RNG = RandStream('mt19937ar');
    %Matriz M con dimensiones LxN
    LSM = 1 + rand(RNG,L,N);

    for k=1:L 
        for i=k+2:N-k+1 
            %%Para cada escala k se asigna el valor 0 en las posiciones
            %%donde se encuentra un mximo local. El resto se mantiene
            if(Signal(i-1)>Signal(i-k-1) && Signal(i-1)>Signal(i+k-1))
                LSM(k,i) = 0;
            end
        end
    end

    %%Paso  2
	G = sum(LSM,2);
    [~,l] = min(G);
    if l<2
        l=2;
    end
    LSM = LSM(1:l,:);

    S = std(LSM);

    varargout{1} = find(S==0)-1;
end